<%@ Page Language="C#" MasterPageFile="~/Registry.master" AutoEventWireup="true" 
    CodeFile="ReportDoDFragment.aspx.cs" Inherits="ReportDoDFragment" 
    MaintainScrollPositionOnPostback="true" %>

<%@ Import  Namespace="System.Web.Security.AntiXss" %>
<asp:Content ID="Content1" ContentPlaceHolderID="head" Runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">
 
    <script type = "text/javascript">

        $(function() {
            if ($('#<%= HiddenFieldClearFlag.ClientID %>').val() === '1')
                $('#<%= TextBoxSearchCriteria.ClientID%>').focus();
        });
    </script>
        <script type="text/javascript" language="javascript">

            $(DocReady);
            function DocReady() {
                $('option[value = MHTML]').remove();
                $('option[value = CSV]').remove();
                $('option[value = EXCELOPENXML]').remove();
                $('option[value = IMAGE]').remove();
                $('option[value = XML]').remove();
            }
     </script>
    <div class="breadcrumb">
        <asp:Label SkinID="DataLabel" ID = "LabelBreadCrumb" runat="server" Text="Reporting > DoD Fragment Report"/>
    </div> 
    
    <br />
   <div class = "excludeSaveWarnings">
   <asp:Label SkinID="DataLabel" ID="LabelforTextBoxSearchCriteria" runat="server" AssociatedControlID="TextBoxSearchCriteria">Filter by Source Lab:</asp:Label>
                            
        <asp:TextBox ID="TextBoxSearchCriteria" runat="server" Width="200px"></asp:TextBox>
        &nbsp;
        <asp:Button ID="ButtonSearch" runat="server" Text=" &nbsp;&nbsp;Go&nbsp;&nbsp; " OnClick = "ButtonOK_Click"
            />
        &nbsp;
        <asp:Button ID="ButtonClear" runat="server" Text=" Clear " OnClick = "ButtonClear_Click" 
            />
        <br />
    </div> 
    
    <asp:GridView ID = "GridViewDoDFragmentFiles" runat = "server" 
        AutoGenerateColumns = "false" OnRowCommand = "DoDFragment_RowCommand" 
        AllowPaging="True" PageSize="20" DataKeyNames = "DOD_FRAGMENT_RAW_DATA_ID" 
        OnRowDataBound = "DoDFragment_RowDataBound" AllowSorting="true" 
        onpageindexchanging="DoDFragment_PageIndexChanging" 
        onselectedindexchanging="DoDFragment_SelectedIndexChanging" 
        onsorting="GridViewDoDFragmentFiles_Sorting">
       <EmptyDataTemplate>
            No DoD Fragment files exist 
       </EmptyDataTemplate> 
        
        <Columns>        
            <asp:TemplateField HeaderText = "DoD Fragment ID" ItemStyle-HorizontalAlign="Center" Visible="false">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID = "LabelDodFragmentRawDataId" runat = "server" Text = '<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("DOD_FRAGMENT_RAW_DATA_ID")), false) %>' ></asp:Label>                 
                </ItemTemplate>    
                
            </asp:TemplateField>
            <asp:TemplateField HeaderText = "Source Lab" SortExpression="SOURCE_LAB" ItemStyle-HorizontalAlign="Center">
                <ItemTemplate>
                    <asp:Label SkinID="DataLabel" ID = "LabelSourceLab" runat = "server" Text = '<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("SOURCE_LAB")), false) %>' ></asp:Label>                 
                </ItemTemplate> 
            </asp:TemplateField>    
                             
            <asp:TemplateField HeaderText="Process Date" SortExpression="CREATED">                    
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelProcessDate" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("CREATED")), false) %>' ></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField>
            
            <asp:TemplateField HeaderText="# Patients">                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelNumberOfPatients" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("NUMBER_OF_PATIENTS")), false) %>'></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField> 
            
            <asp:TemplateField HeaderText="# Records">                   
                    <ItemTemplate>
                        <asp:Label SkinID="DataLabel" ID="LabelNumberOfPatients" runat="server" Text='<%# AntiXssEncoder.HtmlEncode(Convert.ToString(Eval("NUMBER_OF_RECORDS")), false) %>'></asp:Label>
                    </ItemTemplate>
            </asp:TemplateField> 
            
            <asp:ButtonField ButtonType = "Button" Text = "Open / Download" CommandName = "Details"  AccessibleHeaderText = "View File"  />
            
        </Columns>
    </asp:GridView>      
    
    <asp:HiddenField ID="HiddenFieldClearFlag" runat="server" />
    
</asp:Content>









